// RendererD3D11.cpp: implementation of the CRendererD3D11 class.
//
// created by Unwinder
//////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "RendererD3D11.h"

#include <io.h>
//////////////////////////////////////////////////////////////////////
#define SAFE_RELEASE(ptr) if (ptr) { ptr->Release(); ptr = NULL; } 
//////////////////////////////////////////////////////////////////////
CRendererD3D11::CRendererD3D11()
{
	m_hWnd					= NULL;
	m_lpd3dDevice			= NULL; 
	m_lpd3dDeviceContext	= NULL; 
	m_lpd3dRenderTarget		= NULL;
	m_lpSwapChain			= NULL;
}
//////////////////////////////////////////////////////////////////////
CRendererD3D11::~CRendererD3D11()
{
	Uninit();
}
//////////////////////////////////////////////////////////////////////
BOOL CRendererD3D11::Init(HWND hWnd)
{
	//D3D11 can be unavailable (e.g. on Windows XP), so we explicitly check library presence before making any delay loaded D3D11 calls

	char czPath[MAX_PATH];
	GetSystemDirectory(czPath, MAX_PATH);

	strcat_s(czPath, sizeof(czPath), "\\d3d11.dll");

	if (_taccess(czPath, 0))
		return FALSE;

	Uninit();

	m_hWnd = hWnd;

	CRect rc;
	GetClientRect(m_hWnd, &rc);

	D3D_FEATURE_LEVEL featureLevels[] =
		{
			D3D_FEATURE_LEVEL_11_0,
			D3D_FEATURE_LEVEL_10_0,
			D3D_FEATURE_LEVEL_9_1
		};

	DXGI_SWAP_CHAIN_DESC desc;
	ZeroMemory(&desc, sizeof(desc));
	desc.BufferCount							= 1;
	desc.BufferDesc.Width						= rc.Width();
	desc.BufferDesc.Height						= rc.Height();
	desc.BufferDesc.Format						= DXGI_FORMAT_R8G8B8A8_UNORM;
	desc.BufferDesc.RefreshRate.Numerator		= 60;
	desc.BufferDesc.RefreshRate.Denominator		= 1;
	desc.BufferUsage							= DXGI_USAGE_RENDER_TARGET_OUTPUT;
	desc.OutputWindow							= m_hWnd;
	desc.SampleDesc.Count						= 1;
	desc.SampleDesc.Quality						= 0;
	desc.Windowed								= TRUE;

	if (FAILED(D3D11CreateDeviceAndSwapChain(NULL, D3D_DRIVER_TYPE_HARDWARE, NULL, 0, featureLevels, _countof(featureLevels), D3D11_SDK_VERSION, &desc, &m_lpSwapChain, &m_lpd3dDevice, NULL, &m_lpd3dDeviceContext)))
		return FALSE;

	InitRenderTarget();

	CWnd dummy;
	dummy.CreateEx(0, AfxRegisterWndClass(0,::LoadCursor(NULL,IDC_ARROW)), "", WS_POPUP, 0, 0, 0, 0, NULL, NULL);
		//D3D11 is delay loaded for backward compatibility, so we create a dummy popup to force our process to be hooked by RTSS immediately

	return TRUE;
}
//////////////////////////////////////////////////////////////////////
void CRendererD3D11::Uninit()
{
	SAFE_RELEASE(m_lpd3dRenderTarget);
	SAFE_RELEASE(m_lpd3dDeviceContext);
	SAFE_RELEASE(m_lpd3dDevice);
	SAFE_RELEASE(m_lpSwapChain);
}
//////////////////////////////////////////////////////////////////////
void CRendererD3D11::Reset(int x, int y)
{
	if (m_lpSwapChain)
	{
		SAFE_RELEASE(m_lpd3dRenderTarget);
 
		m_lpSwapChain->ResizeBuffers(1, x, y, DXGI_FORMAT_R8G8B8A8_UNORM, 0);

		InitRenderTarget();
	}
}
//////////////////////////////////////////////////////////////////////
void CRendererD3D11::Render(DWORD dwColor)
{
	HRESULT err;

	float color[4] = {(dwColor & 0xFF) / 255.0f, ((dwColor>>8) & 0xFF) / 255.0f, ((dwColor>>16) & 0xFF) / 255.0f, ((dwColor>>24) & 0xFF) / 255.0f};

	if (m_lpd3dRenderTarget)
		m_lpd3dDeviceContext->ClearRenderTargetView(m_lpd3dRenderTarget, color);

	if (m_lpSwapChain)
	{
		err = m_lpSwapChain->Present(0, 0);

		if ((err == DXGI_ERROR_DEVICE_REMOVED	) || 
			(err == DXGI_ERROR_DEVICE_RESET		))
		{
			CRect cr;
			GetClientRect(m_hWnd, &cr);

			Reset(cr.Width(), cr.Height());
		}
	}
}
//////////////////////////////////////////////////////////////////////
void CRendererD3D11::InitRenderTarget()
{
	if (m_lpSwapChain)
	{
	    ID3D11Texture2D* lpBackbuffer = NULL;

		m_lpSwapChain->GetBuffer(0, __uuidof(ID3D11Texture2D), (LPVOID*)&lpBackbuffer);

		if (lpBackbuffer)
		{
			m_lpd3dDevice->CreateRenderTargetView(lpBackbuffer, NULL, &m_lpd3dRenderTarget);

			lpBackbuffer->Release();
		}
	}
}
/////////////////////////////////////////////////////////////////////////////
